<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Turn off error reporting so that if anything goes wrong, your visitor won't know
error_reporting(0);
session_start();

/*
We don't want this page to be cached.  If it is, that might mean that some multiple
clicks aren't properly logged.  These headers will tell the server not to allow any
caching.
*/
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

// Include the configuration files to connect to the database and find the current settings
require ("../config_database.php");
	/*
	If the script can't establish a connection to the database, we might as well quit.
	There's no point in continuing any further if we can't access the database.
	*/
	if (!$adlogger_db_connect || !$adlogger_db_select) {
		exit();
	}
require ("../config_settings.php");

// Include the functions file where the all the functions are defined
require ("./functions/functions.php");

// Set a variable of the visitor's IP address
$visitor_ip = visitorIP();

// Set a variable with the proxy information, if exists
$extrainfo = extra_IP_info();

// The visitor's User Agent information, with the ExtraInfo appended to it
$visitor_agent = mysql_real_escape_string(htmlentities($_SERVER['HTTP_USER_AGENT']));
	if (!empty($extrainfo)) {
		$visitor_agent .= " (Extra IP info: " . $extrainfo . ")";
	}

// Grab the variables that were passed via the URL and set them as variables
$ch_id = grab_from_url('ch_id');
$ad_target = grab_from_url('targ');
$ad_src = mysql_real_escape_string($_GET['src']);

// Parse the src so we can grab the good stuff
parse_str($ad_src);

// Find out what page the visitor clicked an ad on
if (isset($_GET['disp']) && !empty($_GET['disp'])) {
	$disp_url = get_disp_page($_GET['disp']);
} else {
	$disp_url = get_disp_page($_SERVER['HTTP_REFERER']);
}

// Try and determine the page that originally brought that visitor to your site.
if (isset($_SESSION['adlog_ref']) && !empty($_SESSION['adlog_ref'])) {
	$ref = get_disp_page($_SESSION['adlog_ref']);
} else {
	$ref = '';
}

// Go ahead and insert all that information into a row in the database
mysql_query("INSERT INTO " . $db_table_prefix . "adcheck_logs SET
		timestamp ='$timestamp',
		visitor_ip='$visitor_ip'
	");

mysql_query("INSERT INTO " . $db_table_prefix . "logfiles SET
		timestamp ='$timestamp',
		visitor_ip='$visitor_ip',
		visitor_agent='$visitor_agent',
		ch_id='$ch_id',
		disp_url='$disp_url',
		ref='$ref',
		targ_url='$ad_target',
		click_type='1',
		disp_time='$lmt',
		format='$format',
		color_bg='$color_bg',
		color_txt='$color_text',
		color_lnk='$color_link',
		color_url='$color_url',
		color_brd='$color_border',
		ad_type='$ad_type'
	");

$result_id = mysql_insert_id();

/*
Find out how many ads this person has clicked recently.  "Recently" is any time
between now and the click max time in the click fraud settings.
*/
$backlog_timeframe = $timestamp - $clickmaxtime;
$result = mysql_query("SELECT COUNT(visitor_ip) FROM " . $db_table_prefix . "logfiles WHERE visitor_ip = '$visitor_ip' AND timestamp > '$backlog_timeframe'");
	$row = mysql_fetch_array($result);
	$visitors_recent_clicks = $row['COUNT(visitor_ip)'];

// The current date and time relative to the AdLogger timezone setting
$date = date('l, F j, Y', $timestamp);
$time = date('g:i:s A', $timestamp);

/*
If the option to receive Email Alerts is enabled AND
the number of clicks from that visitor exceeds the
"Alert me after so many emails.." number, then go ahead
and sent the multiple click alert email
*/
if ($email_alert && ($visitors_recent_clicks >= $emailalert_num)) {

	$msg = "AdLogger reports a multiple click by one of your visitors. The details of the report are below:<BR><BR>
	Visitor IP - $visitor_ip<BR><BR>
	Date/Time of click - $time on $date<BR><BR>
	AdLogger estimates this person has clicked a total of $visitors_recent_clicks ads.<BR><BR>
	Page of the click - <a href=\"" . $disp_url . "\">" . $disp_url . "</a><BR><BR><BR>
	More information: <a href=\"" . $siteurl . $adlogger_loc . "/admin/click_info.php?id=" . $result_id . "\">" . $siteurl . $adlogger_loc . "/admin/click_info.php?id=" . $result_id . "</a>
	";

	$subject = "AdLogger Multiple Click Notification";
	$mailheaders = "MIME-Version: 1.0\n";
	$mailheaders .= "Content-type: text/html; charset=iso-8859-1\n";

	$to = $email;
	$mailheaders .= "From: AdLogger <$email>\n";
	$mailheaders .= "Reply-To: $email";

	mail($to, $subject, $msg, $mailheaders);

/*
If the option to receive an email notice for clicks is enabled,
go ahead and send the email
*/
} elseif ($email_notice) {

	$msg = "AdLogger reports a click on your site. It reports the following:<BR><BR>
	Visitor IP - $visitor_ip<BR><BR>
	Date/Time of click - $time on $date<BR><BR>
	Page of the click - <a href=\"" . $disp_url . "\">" . $disp_url . "</a><BR><BR><BR>
	More information: <a href=\"" . $siteurl . $adlogger_loc . "/admin/click_info.php?id=" . $result_id . "\">" . $siteurl . $adlogger_loc . "/admin/click_info.php?id=" . $result_id . "</a>
	";

	$subject = "AdLogger Click Notification";
	$mailheaders = "MIME-Version: 1.0\n";
	$mailheaders .= "Content-type: text/html; charset=iso-8859-1\n";

	$to = $email;
	$mailheaders .= "From: AdLogger <$email>\n";
	$mailheaders .= "Reply-To: $email";

	mail($to, $subject, $msg, $mailheaders);
}
?>